document.addEventListener('DOMContentLoaded', async () => {
// ========== 1. 更新提示区域 ==========
const updateBanner = document.getElementById('updateBanner');
const currentVerEl = document.getElementById('currentVer');
const newVerEl = document.getElementById('newVer');
const downloadLink = document.getElementById('downloadLink');

// 显示当前插件版本
const currentVersion = chrome.runtime.getManifest().version;
currentVerEl.textContent = currentVersion;

// 从 storage 读取远程信息（由 background 脚本提前写入）
const result = await chrome.storage.local.get(['latestRemoteVersion', 'remoteUpdateInfo']);
const latestRemoteVersion = result.latestRemoteVersion;
const remoteUpdateInfo = result.remoteUpdateInfo;

if (latestRemoteVersion && latestRemoteVersion !== currentVersion) {
  // 显示新版本号
  newVerEl.textContent = latestRemoteVersion;

  // 🔁 与 background.js 完全一致的 jumpUrl 逻辑
  const jumpUrl = remoteUpdateInfo?.download_url || 'https://www.maiyauto.cn/plugin/help.html';

  // 设置链接
  downloadLink.href = jumpUrl;
  downloadLink.onclick = (e) => {
    e.preventDefault();
    chrome.tabs.create({ url: jumpUrl });
    window.close(); // 可选：点击后关闭 popup
  };

  updateBanner.style.display = 'block';
} else {
  updateBanner.style.display = 'none';
}

  // ========== 2. Webhook 配置区域 ==========
  const urlInput = document.getElementById('webhookUrl');
  const saveBtn = document.getElementById('saveBtn');
  const statusDiv = document.getElementById('status');

  // 从 storage 读取已保存的 URL
  chrome.storage.sync.get(['webhookUrl'], (result) => {
    if (result.webhookUrl) {
      urlInput.value = result.webhookUrl;
    }
  });

  saveBtn.addEventListener('click', () => {
    const url = urlInput.value.trim();
    if (!url) {
      showStatus('URL 不能为空', 'error');
      return;
    }

    try {
      new URL(url); // 验证是否为合法 URL
    } catch (e) {
      showStatus('请输入有效的 URL', 'error');
      return;
    }

    if (!url.includes('qyapi.weixin.qq.com') || !url.includes('/webhook/send')) {
      showStatus('URL 应为企业微信机器人地址', 'error');
      return;
    }

    chrome.storage.sync.set({ webhookUrl: url }, () => {
      showStatus('✅ 保存成功！', 'success');
    });
  });

  function showStatus(text, type) {
    statusDiv.textContent = text;
    statusDiv.className = 'status ' + type;
  }
});